<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('developers_real_estates', function (Blueprint $table) {
            $table->id();
            $table->string('name', 120)->unique();
            $table->text('desc');
            $table->string('logo', 120);
            $table->string('email', 120)->nullable();
            $table->string('license_number', 120)->nullable();

            // Relation
            $table->unsignedBigInteger('created_by')->nullable();
            $table->foreign('created_by')->references('id')->on('admins')->onDelete("set null")->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('developers_real_estates');
    }
};
